# coding=utf-8

"""
Collect stats from the nsd resolver

#### Dependencies

    * collections.defaultdict or kitchen

"""

try:
    from collections import defaultdict
except ImportError:
    from kitchen.pycompat25.collections import defaultdict

import diamond.collector
from diamond.collector import str_to_bool


class NsdCollector(diamond.collector.ProcessCollector):

    def get_default_config_help(self):
        config_help = super(NsdCollector, self).get_default_config_help()
        config_help.update({
            'bin':          'Path to nsd-control binary',
        })
        return config_help

    def get_default_config(self):
        """
        Returns the default collector settings
        """
        config = super(NsdCollector, self).get_default_config()
        config.update({
            'path':         'nsd',
            'bin':          self.find_binary('/usr/sbin/nsd-control'),
        })
        return config

    def collect(self):
        stats_output = self.run_command([' stats'])
        if stats_output is None:
            return

        stats_output = stats_output[0]

        for line in stats_output.splitlines():
            stat_name, stat_value = line.split('=')

            self.publish(stat_name, stat_value)
