import ldap
import json
import diamond.collector

class OpenDJCollector(diamond.collector.Collector):
    STATS = {
        'conns.total': {
            'base': 'cn=monitor',
            'attr': 'ds-mon-total-connections'},
        'conns.current': {
            'base': 'cn=monitor',
            'attr': 'ds-mon-current-connections'},
        'conns.bytesWritten': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-bytes-written'},
        'conns.bytesRead': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-bytes-read'},
        'conns.active': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-active-connections-count'},
        'conns.total': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-connections'},
        'requests.abandon': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-abandoned-requests'},
        'requests.add': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-add'},
        'requests.bind': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-bind'},
        'requests.compare': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-compare'},
        'requests.delete': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-delete'},
        'requests.extended': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-extended'},
        'requests.modifyDN': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-modify-dn'},
        'requests.modify': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-modify'},
        'requests.search': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-search-base'},
        'requests.searchOne': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-search-one'},
        'requests.searchSub': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-search-sub'},
        'requests.unbind': {
            'base': 'cn=LDAPS Connection Handler,cn=Connection Handlers,cn=monitor',
            'attr': 'ds-mon-requests-unbind'},
        'workqueue.requests.submitted': {
            'base': 'cn=work queue,cn=monitor',
            'attr': 'ds-mon-requests-submitted'},
        'workqueue.requests.reject': {
            'base': 'cn=work queue,cn=monitor',
            'attr': 'ds-mon-requests-rejected-queue-full'},
        'workqueue.backlog': {
            'base': 'cn=work queue,cn=monitor',
            'attr': 'ds-mon-requests-in-queue'},
        'backends.userRoot.entries': {
            'base': 'ds-cfg-backend-id=userRoot,cn=backends,cn=monitor',
            'attr': 'ds-mon-backend-entry-count'},
        'mem.usage.oldgen': {
            'base': 'cn=jvm,cn=monitor',
            'attr': 'ds-mon-jvm-memory-pools-cms-old-gen-used'},
        'mem.usage.survivor': {
            'base': 'cn=jvm,cn=monitor',
            'attr': 'ds-mon-jvm-memory-pools-par-survivor-space-used'},
        'mem.usage.codecache': {
            'base': 'cn=jvm,cn=monitor',
            'attr': 'ds-mon-jvm-memory-pools-code-cache-used'},
        'mem.usage.edenspace': {
            'base': 'cn=jvm,cn=monitor',
            'attr': 'ds-mon-jvm-memory-pools-par-eden-space-used'},
        'mem.usage.metaspace': {
            'base': 'cn=jvm,cn=monitor',
            'attr': 'ds-mon-jvm-memory-pools-metaspace-used'},
    }

    def get_default_config_help(self):
        config_help = super(OpenDJCollector, self).get_default_config_help()
        config_help.update({
          'path': 'opendj',
          'uri':  'LDAP uri to connect to for stats',
          'binddn': 'DN for bind to LDAP uri',
          'bindpw_file': 'file containing password for bind to LDAP uri'
        })
        return config_help

    def get_default_config(self):
        """
        Returns the default collector settings
        """
        config = super(OpenDJCollector, self).get_default_config()
        config.update({
            'path': 'opendj',
            'uri':  'ldaps://localhost:636',
            'binddn': 'cn=replicationadmin,cn=Administrators,cn=admin data',
            'bindpw_file': '/var/lib/sandstorm-agent/secrets/resource-opendj_user_replicationadmin.sandstorm'
        })
        return config

    def _get_raw_data(self, ldap_url, binddn, bindpw):
        _res = {}
        # perform the search in bulk, return all of it
        # ldapsearch -x -H ldaps://localhost:636/ -b 'cn=Monitor'
        _base = 'cn=Monitor'
        _search = '(objectClass=*)'

        try:
            _conn = ldap.initialize(ldap_url)
            _conn.simple_bind_s(binddn, bindpw)
            _num = _conn.search(_base, ldap.SCOPE_SUBTREE, _search)
            _res_type, _res_data = _conn.result(_num, 1) # 1 here waits for/returns _all_ results
            _res = _res_data
        except Exception, e:
            self.log.warn('Unable to query ldap base=%s, err: %s'
                % (_base, str(e)))
            raise

        return _res

    def get_datapoints(self, ldap_url, binddn, bindpw):
        _query = self._get_raw_data(ldap_url, binddn, bindpw)
        datapoints = {}

        try:
            for key in self.STATS.keys():
                base = self.STATS[key]['base']
                attr = self.STATS[key]['attr']
                for i,k in _query:
                    if i == base:
                        # KLUDGE.
                        if k[attr][0].startswith('{'):
                            attrdict = json.loads(k[attr][0])
                            datapoints[key] = attrdict['count']
                        else:
                            datapoints[key] = k[attr][0]
        except:
            self.log.warn('Unable to query ldap base=%s, attr=%s'
                          % (base, attr))
            raise

        return datapoints

    def collect(self):
        try:
            pwf = open(self.config['bindpw_file'],'r')
            bindpw = pwf.read()
            datapoints = self.get_datapoints(self.config['uri'], self.config['binddn'], bindpw)
        except Exception, e:
            self.log.error('Unable to query %s: %s' % (self.config['uri'], str(e)))
            return {}

        # Publish Metric
        for name, value in datapoints.items():
          self.publish(name, value)
