# coding=utf-8

"""
Collect postfix queue sizes

#### Dependencies

    * collections.defaultdict or kitchen

"""

import os
import diamond.collector

try:
    from collections import defaultdict
except ImportError:
    from kitchen.pycompat25.collections import defaultdict

import diamond.collector

class PostfixQueueCollector(diamond.collector.ProcessCollector):

    def get_default_config_help(self):
        config_help = super(PostfixQueueCollector, self).get_default_config_help()
        config_help.update({
            'queue_directory':          'path to postfix\'s queue_directory',
        })
        return config_help

    def get_default_config(self):
        """
        Returns the default collector settings
        """
        config = super(PostfixQueueCollector, self).get_default_config()
        config.update({
            'path':         'postfix.queue',
            'queue_directory':         '/var/spool/postfix',
        })
        return config

    def collect(self):
        stats = {} 
        queue_dirs = ['active','bounce','deferred','hold','incoming']
        queue_total = 0
        
        for dir in queue_dirs:
            for root, subdirs, files in os.walk(self.config['queue_directory'] + '/' + dir):
                queue_count = 0
                for file in files:
                    queue_count += 1
                    queue_total += 1
                stats[dir] = queue_count
                self.publish_gauge(dir, stats[dir])
