# coding=utf-8

"""
Collect metrics from puppet server

"""
import urllib2
import json
import ssl
import ConfigParser
import diamond.collector

PUPPET_CONF = "/etc/puppet/puppet.conf"
PREFIX = "puppetlabs"
METRICS_TO_PULL = {
    "http.active-histo": ['Mean'],
    "http.active-requests": ['Count'],
    "http.other-requests": ['Mean'],
    "http.puppet-v3-catalog-all-requests": ['Mean'],
    "http.puppet-v3-file_content-all-requests": ['Mean'],
    "http.puppet-v3-file_metadata-all-requests": ['Mean'],
    "http.puppet-v3-file_metadatas-all-requests": ['Mean'],
    "http.puppet-v3-node-all-requests": ['Mean'],
    "http.puppet-v3-report-all-requests": ['Mean'],
    "http.total-requests": ['Mean', '50thPercentile', '95thPercentile'],
    "jruby.borrow-timer": ['Mean'],
    "jruby.free-jrubies-histo": ['Mean'],
    "jruby.lock-held-timer": ['Mean'],
    "jruby.lock-wait-timer": ['Mean'],
    "jruby.num-free-jrubies": ['Value'],
    "jruby.num-jrubies": ['Value'],
    "jruby.requested-jrubies-histo": ['Mean'],
    "jruby.wait-timer": ['Mean'],
    "memory.heap.used": ['Value'],
    "memory.non-heap.used": ['Value']
}

class PuppetServerCollector(diamond.collector.Collector):

    def __init__(self, *args, **kwargs):
        super(PuppetServerCollector, self).__init__(*args, **kwargs)
        # let's read ca_server value from the puppet config
        config = ConfigParser.ConfigParser()
        config.read(PUPPET_CONF)
        ca_server = config.get('main', 'ca_server')
        # evil hack to bypass cert check for https://127.0.0.1
        self.ctx = ssl.create_default_context()
        self.ctx.check_hostname = False
        self.ctx.verify_mode = ssl.CERT_NONE

        self.metrics_req_data = []
        self.metrics_names = []
        req = urllib2.Request(self.config['metrics_api'])
        handle = urllib2.urlopen(req, context=self.ctx)
        for metric_name in json.loads(handle.read()).keys():
            metric_name_parts = metric_name.split(":")
            if metric_name_parts[0] == "puppetserver":
                normalized_name = metric_name_parts[1].split("=")[1].replace('"', '').replace('/\*/', 'all')
                for suffix in METRICS_TO_PULL.keys():
                    other_name = ".".join([PREFIX, ca_server, suffix])
                    if other_name == normalized_name:
                        self.metrics_req_data.append(metric_name)
                        self.metrics_names.append(suffix)
        self.metrics_req_data = json.dumps(self.metrics_req_data)

    def get_default_config_help(self):
        config_help = super(PuppetServerCollector, self).get_default_config_help()
        config_help.update({
            'metrics_api': 'URL of the puppet server metrics API endpoint',
        })
        return config_help

    def get_default_config(self):
        """
        Returns the default collector settings
        """
        config = super(PuppetServerCollector, self).get_default_config()
        config.update({
            'path':        'puppetserver',
            'metrics_api': 'https://127.0.0.1:8140/metrics/v1/mbeans',
        })
        return config

    def collect(self):
        try:
            req = urllib2.Request(self.config['metrics_api'], self.metrics_req_data)
            req.add_header('Content-Type', 'application/json')
            handle = urllib2.urlopen(req, context=self.ctx)
            for idx, metrics_vals in enumerate(json.loads(handle.read())):
                for val_name in METRICS_TO_PULL[self.metrics_names[idx]]:
                    val = metrics_vals.get(val_name, 0)
                    self.publish("{}.{}".format(self.metrics_names[idx], val_name), val, precision=2)
        except Exception as e:
            if not hasattr(e, 'code') or e.code != 401:
                self.log.error("Error retrieving metrics. %s", e)
