# Adds a collector file to disk.
#
define twitch_diamond::collector (
  $enable             = true,
  $options            = {},
  $subsection_options = {},
  $source             = false,
  $content            = undef,
) {
  include twitch_diamond

  file { "${::twitch_diamond::params::diamond_configs_d}/${name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/collector.conf.erb"),
    notify  => Class['twitch_diamond::service'],
  }

  # Either source or content, never both
  if str2bool($source) and $content == undef {
    file { "${::twitch_diamond::params::diamond_collectors_d}/${name}.py":
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      source  => "puppet:///modules/${module_name}/${name}.py",
      require => Class['twitch_diamond::install'],
      notify  => Class['twitch_diamond::service'],
    }
  }

  if $content != undef and str2bool($source) == false {
    file { "${::twitch_diamond::params::diamond_collectors_d}/${name}.py":
      ensure  => file,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => $content,
      require => Class['twitch_diamond::install'],
      notify  => Class['twitch_diamond::service'],
    }
  }
}
