# Creates configurations folders and files for diamond.
#
class twitch_diamond::config inherits twitch_diamond {
  # a requirement for ArchiveHandler which is enabled only on few boxes
  file { '/var/log/diamond':
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file {[
    $twitch_diamond::params::diamond_d,
    $twitch_diamond::params::diamond_configs_d,
    $twitch_diamond::diamond_handlers_d,
  ]:
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    purge   => true,
    force   => true,
    recurse => true,
  }

  file { $twitch_diamond::params::diamond_config:
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/diamond.conf.erb"),
    notify  => Class['Twitch_diamond::Service'],
  }

  create_resources(twitch_diamond::collector, $twitch_diamond::params::merge_collectors)
  create_resources(twitch_diamond::handler, $twitch_diamond::params::merge_handlers)
}
