# Adds a diamond handler file.
#
define twitch_diamond::handler (
  $handler_name,
  $enable      = true,
  $options     = undef,
  $subsections = undef,
  $source      = false,
) {
  include twitch_diamond

  file {"${::twitch_diamond::params::diamond_configs_d}/${name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/handler.conf.erb"),
    notify  => Class['Twitch_diamond::Service'],
  }

  if ($source) {
    $dir = "${::twitch_diamond::params::diamond_handlers_d}/${name}"
    file { $dir:
      ensure => 'directory',
      owner  => 'root',
      group  => 'root',
      mode   => '0750',
    }
    file { "${dir}.py":
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      source  => "puppet:///modules/${module_name}/${name}.py",
      require => File[$dir],
      notify  => Class['Twitch_diamond::Service'],
    }
  }

}
