# Twitch Diamond Parameters!
#
class twitch_diamond::params {
  $ensure                  = '4.0.515-700'
  $diamond_base            = '/opt/twitch/video-diamond'
  $diamond_d               = '/etc/diamond'
  $diamond_config          = "${diamond_d}/diamond.conf"
  $diamond_configs_d       = "${diamond_d}/configs"
  $diamond_script          = "${diamond_base}/bin/diamond"
  $diamond_collectors_d    = "${diamond_base}/share/diamond/collectors"
  $diamond_handlers_d      = "${diamond_base}/share/diamond/handlers"
  $diamond_poll_interval   = hiera('twitch_diamond::diamond_poll_interval', 60)
  $diamond_path_prefix     = 'servers'
  $diamond_hostname_method = 'fqdn'
  $diamond_user            = ''
  $diamond_group           = ''
  $process_manager         = 'upstart'
  $metrics                 = hiera_hash('twitch_diamond::metrics',{})
  $handlers                = hiera_hash('twitch_diamond::handlers', {})
  $aws_region              = hiera('twitch_diamond::aws_region', $::default_region)
  $diamond_base_handlers   = hiera_hash('twitch_diamond::diamond_base_handlers', {
    'TwitchCloudwatchHandler' => {
      handler_name => 'TwitchCloudwatchHandler.TwitchCloudwatchHandler',
      source       => true,
      options      => {
          pop         => $::pop,
          role        => $::twitch_role,
          environment => $::twitch_environment,
      },
    },
  })
  $tcp_metrics_default     = [
    'ActiveOpens',
    'AttemptFails',
    'CurrEstab',
    'EstabResets',
    'InErrs',
    'ListenDrops',
    'ListenOverflows',
    'PassiveOpens',
    'RetransSegs',
    'TCPAbortOnMemory',
    'TCPBacklogDrop',
    'TCPFastRetrans',
    'TCPForwardRetrans',
    'TCPLoss',
    'TCPLostRetransmit',
    'TCPSlowStartRetrans',
    'TCPTimeouts',
  ]

  $metrics_interfaces      = [
    'eth',
    'bond',
    'em',
    'p1p',
    'eno',
    'enp',
    'ens',
    'enx',
    'team',
  ]

  $default_diamond_base_collectors = {
    'CPUCollector'         => {
      options => {
        percore => false,
      },
    },
    'TCPCollector'         => {
      options => {
        byte_unit => 'byte',
      },
    },
    'NetworkCollector'     => {
      options => {
        byte_unit  => 'bit',
        interfaces => join($metrics_interfaces,','),
      },
    },
    'IPCollector'          => {},
    'DiskSpaceCollector'   => {},
    'DiskUsageCollector'   => {},
    'LoadAverageCollector' => {},
    'MemoryCollector'      => {},
    'ProcessStatCollector' => {},
    'VMStatCollector'      => {},
    'SockstatCollector'    => {},
  }
  $diamond_base_collectors = hiera_hash('twitch_diamond::diamond_base_collectors', $default_diamond_base_collectors)

  if has_key($diamond_base_collectors, 'TCPCollector') {
    $tcp_collector = {
      'TCPCollector'         => {
        options => {
          byte_unit     => 'byte',
          allowed_names => join(hiera_array('twitch_diamond::tcp_metrics_filter', $tcp_metrics_default), ','),
        },
      },
    }
  } else {
    $tcp_collector = {}
  }

  $merge_collectors = merge($diamond_base_collectors, $tcp_collector, $metrics)
  $merge_handlers   = merge($diamond_base_handlers, $handlers)
  # $extra_handlers   = hiera_hash('twitch_diamond::diamond_extra_handlers', {})
}
