# Sets up and starts the diamond service and watcher.
#
class twitch_diamond::service inherits twitch_diamond {
  case $twitch_diamond::process_manager {
    'systemd': {

      case $twitch_diamond::ensure {
        'absent': {
          $_service_ensure = stopped
          $_service_enable = false
        }
        default: {
          $_service_ensure = running
          $_service_enable = true
        }
      }

      twitch_systemd::unit_file {'diamond.service':
        content => template("${module_name}/systemd-diamond.erb"),
        notify  => Service['diamond'],
      }

      service { 'diamond':
        ensure  => $_service_ensure,
        enable  => $_service_enable,
        require => Class['::systemd'],
      }
    }
    default: { fail("Do not understand how to deal with \$process_manager = ${twitch_diamond::process_manager}") }
  }
}
