# class twitch_dirs
class twitch_dirs(
  $twitch_basedir = $twitch_dirs::params::twitch_basedir,
  $deploy_user    = $twitch_dirs::params::deploy_user,
  $deploy_group   = $twitch_dirs::params::deploy_group,
) inherits twitch_dirs::params {

  file{ '/var/chroot':
    ensure => directory,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file{ '/opt':
    ensure => directory,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file{ $twitch_basedir:
    ensure  => directory,
    owner   => $deploy_user,
    group   => $deploy_group,
    mode    => '0755', ### 0775? w/diff group ownership?
    require => File['/opt'],
  }

  file { '/home/users':
    ensure => directory,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

}
