# twitch_disktune
class twitch_disktune {

  exec { 'remove disktune start/stop links':
    command => '/usr/sbin/update-rc.d -f disktune remove',
    onlyif  => 'ls /etc/rc*.d/*disktune > /dev/null 2>&1',
  }

  file { '/etc/init.d/disktune':
    ensure  => 'absent',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Exec['remove disktune start/stop links'],
  }

  $ssd_array = split($::ssd, ',')
  twitch_disktune::scheduler { $ssd_array:
    scheduler => 'noop'
  }
  $ssd_nr_requests = versioncmp($::kernelrelease, '4.15') ? {
    1       => '32',
    default => '512'
  }
  twitch_disktune::nr_requests { $ssd_array:
    nr_requests => $ssd_nr_requests
  }
  twitch_disktune::rotational { $ssd_array:
    rotational => 0
  }
  twitch_disktune::read_ahead_kb { $ssd_array:
    read_ahead_kb => 2048
  }

  $hdd_array = split($::hdd, ',')
  twitch_disktune::scheduler { $hdd_array:
    scheduler => 'deadline'
  }
  twitch_disktune::nr_requests { $hdd_array:
    nr_requests => 128
  }
  twitch_disktune::rotational { $hdd_array:
    rotational => 1
  }
  twitch_disktune::read_ahead_kb { $hdd_array:
    read_ahead_kb => 512
  }

  $raid_array = split($::raid, ',')
  twitch_disktune::scheduler{ $raid_array:
    scheduler => 'noop'
  }
  twitch_disktune::nr_requests{ $raid_array:
    nr_requests => 975
  }
  twitch_disktune::rotational{ $raid_array:
    rotational => 0
  }
  twitch_disktune::read_ahead_kb{ $raid_array:
    read_ahead_kb => 4096
  }

}
