# set io scheduler
define twitch_disktune::scheduler (
  $scheduler = 'deadline'
) {

  $drive = $name

  if $drive in $::multiple_queue_devices {
    case $scheduler {
      'deadline': { $_scheduler = 'mq-deadline' }
      'noop':     { $_scheduler = 'none' }
      default:    { $_scheduler = $scheduler }
    }
  } else {
    $_scheduler = $scheduler
  }

  sysfs::setting { "class/block/${drive}/queue/scheduler":
    value => $_scheduler
  }

}
