# twitch_dkms

## Overview 

Manage dkms driver packages

## Usage

```puppet
include twitch_dkms

class { 'twitch_dkms': }
```

To add support for a new dkms package, just add the required info to twitch_dkms::params::driver_info which the `twitch_dkms::module` function uses to configure and install drivers.
```puppet
'name of module' => {
  'package_name'    => 'example-dkms', # deb package name
  'package_version' => '1.2.2',        # deb package version
  'dkms_name'       => 'example_core'  # dkms module name
  'dkms_version'    => '1.2'           # dkms module version
},
```

You can also override with hiera:
```puppet
twitch_dkms::driver_info:
  mlx5_core:
    package_version: 4.2.1
    version: 4.2
```

## Facts

### $::network_drivers

Returns comma seperated list of active network drivers

## Caveats

* may add a significant amount of time to puppet runs, as compiling the driver is required
* requires 4.10 kernel
