#
define twitch_dkms::module () {

  include twitch_dkms

  if has_key ($twitch_dkms::driver_info, $name) {

    $package_name     = $twitch_dkms::driver_info[$name]['package_name']
    $package_version  = $twitch_dkms::driver_info[$name]['package_version']
    $dkms_name        = $twitch_dkms::driver_info[$name]['dkms_name']
    $dkms_version     = $twitch_dkms::driver_info[$name]['dkms_version']
    $interfaces_array = split($facts["interfaces_${name}"], ',')

    # autoload driver at boot
    file { "/etc/modules-load.d/${name}.conf":
      ensure  => 'present',
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/module.erb"),
    }

    # permanently configure the link names of all our interfaces using the current driver $name
    # uses systemd.link
    twitch_dkms::link { $interfaces_array:
      driver => $name,
      notify => Class['twitch_dkms::initramfs'],
    }

    package { $package_name:
      ensure => $package_version,
    }

    dkms::module { $dkms_name:
      ensure  => 'installed',
      kernel  => 'all',
      version => $dkms_version,
      require => Package[$package_name],
    }

  }

}
