#!/usr/bin/env python3
#
# Reimplement ethtool tuning from interfaces(5) ethtool hooks script
# into a standalone utility.
#

import configparser
import subprocess
import sys

Config = configparser.ConfigParser()
Config.read("/etc/ethtune.conf")

failed_updates = list()
for intf in Config.sections():
    print("Parsing settings for interface: {0}".format(intf))
    options = Config.options(intf)
    for option in options:
        ethtool_env = dict()
        value = Config.get(intf, option)
        ethtool_env['IFACE'] = intf
        option_ethtool = 'IF_' + option.upper().replace('-', '_')
        ethtool_env[option_ethtool] = value
        try:
            subprocess.check_output(['/etc/network/if-up.d/ethtool'], env=ethtool_env, stderr=subprocess.STDOUT)  # noqa: E501
        except subprocess.CalledProcessError as e:
            print("Failed to set {} {}: {}:".format(intf, {option: value}, e))
            # format ethtool output to be tabbed in once for debugging ease
            print("{}".format('\t'.join(('\t'+e.output.lstrip()).splitlines(True))).rstrip())  # noqa: E501
            failed_updates += {intf: option}

if len(failed_updates) > 0:
    # if we have encountered an error during our serial runs of ethtool
    # make sure we exit the whole script with > 0
    sys.exit(1)
