#!/usr/bin/env bash

set -x

# Prints the kernel name of each network device that is using the ixgbe (Intel 10GbE) driver.
get_ixgbe_netdevs() {
    for NETDEV_PATH in /sys/class/net/*; do
	DRIVER_PATH="$(readlink -f "${NETDEV_PATH}"/device/driver)"
	test x"${DRIVER_PATH##*/}" = x"ixgbe" && echo "${NETDEV_PATH##*/}"
    done
}

ixgbe_netdevs=$(get_ixgbe_netdevs)

while getopts "c" opt; do
  case ${opt} in
    c )
      [[ -z "${ixgbe_netdevs}" ]] && exit 1
      ;;
  esac
  exit 0
done

for NETDEV in $ixgbe_netdevs; do
    # Tweak RSS behavior: match current number of rx queues. 
    # Some NICs only support a limited number of rx queues.
    # Others create a rx queue per processor count (including hyperthreaded processors)
    number_rx_queues=$(ethtool -x ${NETDEV}| grep -cP  "\s+\d+:\s+")
    ethtool -X "${NETDEV}" weight $(printf '1%.0s ' $(seq 1 ${number_rx_queues}))
done
