class twitch_ethtune (
$interfaces = $twitch_ethtune::params::interfaces,
$settings   = $twitch_ethtune::params::settings,
) inherits twitch_ethtune::params {

  require twitch_python
  require ethtool

  twitch_ethtune::tx_queue_len { $::twitch_ethtune::interfaces: }

  $merged_settings = merge($twitch_ethtune::defaults,
    $twitch_ethtune::speed_settings,
    $twitch_ethtune::settings)

  anchor { 'wrapper::begin': }
  -> class { '::twitch_ethtune::install': }
  -> class { '::twitch_ethtune::config': }
  -> class { '::twitch_ethtune::service':
      subscribe => [
        Class['::twitch_ethtune::install'],
        Class['::twitch_ethtune::config'],
      ],
  }
  -> anchor { 'wrapper::end': }

}
