class twitch_ethtune::params {

  $interfaces = split($::interfaces_with_link,',')
  $defaults           = {
    'ethernet-pause-rx'              => 'on',
    'ethernet-pause-tx'              => 'on',
    'hardware-dma-ring-rx'           => '2048',
    'hardware-irq-coalesce-rx-usecs' => '1',
  }
  case $::max_nic_speed {
    '25000':  {
      $speed_settings = {
        'hardware-irq-coalesce-adaptive-rx' => 'off',
        'hardware-irq-coalesce-rx-usecs'    => '8',
        'hardware-irq-coalesce-rx-frames'   => '32',
        'hardware-irq-coalesce-tx-usecs'    => '16',
        'hardware-irq-coalesce-tx-frames'   => '32'
      }
      $settings       = {}
    }
    default: {
      $speed_settings = {}
      $settings       = {}
    }
  }

}
