# Configures the receive flow hash indirection table
class twitch_ethtune::rxfh_indir {

  $basedir = '/usr/local/lib'
  $tune_sh = 'tune-nics.sh'

  # ethtool wrapper because the provider doesnt (yet) support -X ethtool flag
  file { "${basedir}/${tune_sh}":
    source => "puppet:///modules/${module_name}/${tune_sh}",
    owner  => 'root',
    group  => 'root',
    mode   => '0750',
  }

  # This script can only work if we have a patched ixgbe
  # onlyif here guards against running the script and having it error
  # idempotency to be added later, otherwise its harmless to have ethtool
  # set the options again
  exec { "${basedir}/${tune_sh}":
    onlyif  => "${basedir}/${tune_sh} -c",
    require => File["${basedir}/${tune_sh}"],
  }

}
