class twitch_ethtune::service {

  if versioncmp($::lsbmajdistrelease, '15.04') >= 0 {
    twitch_systemd::unit_file { 'ethtune.service':
      content => template("${module_name}/ethtune.service.erb"),
    }

    service { 'ethtune.service':
      ensure  => running,
      enable  => true,
      require => Twitch_systemd::Unit_file['ethtune.service'],
    }
  } else {
    upstart::job { 'ethtune':
      description => 'Manage ethtool settings',
      script      => '/usr/local/bin/ethtune.py 2>&1 | logger -t ethtune -p daemon.info',
      respawn     => false,
      start_on    => '( starting network-interface or starting networking )',
    }
  }

}
