# Twitch Firewall

This module enforces `iptables` rules from hiera. If this module is
applied/included it **will turn on iptables**, if there are any rules specified in
the hosts hiera lookup path, it will enforce their existence. If the machine
has `iptables` rules already on it that are not defined in hiera, they will be
purged. **Only rules defined in hiera** are managed. Hand applied rules are wiped.

Currently default firewall rules are located in the lowest common layer of
`hiera/clean/true.yaml`. These rules are meant to be generic to all machines in
clean.

Rules can be overridden or added to using higher levels in hiera, they will be
merged with any other rules in hiera levels using `hiera_hash()` function in
puppet.

### Configuration

  * `twitch_firewall::enable` boolean switch to change default INPUT
    policy of firewall to **DROP**, Default: `false`
  * `twitch_firewall::rules::pre` hash of rules to apply first
  * `twitch_firewall::rules::post` hash of rules to apply last

### Default Rules

Here is output from `iptables-save` from our current default ruleset. Note the
`INPUT DROP` and `FORWARD DROP`.

This snippet can be injected directly into `iptables` using `iptables-restore <
<snippet.file>`.


```
# Generated by iptables-save v1.4.12 on Thu Mar 19 04:09:15 2015
*raw
:PREROUTING ACCEPT [16492:23053817]
:OUTPUT ACCEPT [4266:306766]
-A PREROUTING -m comment --comment "005 NOTRACK from ipset CleanHosts" -m set
--match-set CleanHosts src -j NOTRACK
-A PREROUTING -m comment --comment "015 NOTRACK from ipset DMZHosts" -m set
--match-set DMZHosts src -j NOTRACK
-A PREROUTING -i lo -m comment --comment "025 NOTRACK lo interface" -j NOTRACK
-A PREROUTING -p tcp -m multiport --dports 22 -m comment --comment "035 NOTRACK
all ssh" -j NOTRACK
-A PREROUTING -p tcp -m comment --comment "040 NOTRACK consul tcp" -m set
--match-set ConsulTCPPorts dst -j NOTRACK
-A PREROUTING -p udp -m comment --comment "045 NOTRACK consul udp" -m set
--match-set ConsulTCPPorts dst -j NOTRACK
-A OUTPUT -m comment --comment "010 NOTRACK to ipset CleanHosts" -m set
--match-set CleanHosts dst -j NOTRACK
-A OUTPUT -m comment --comment "020 NOTRACK to ipset DMZHosts" -m set
--match-set DMZHosts dst -j NOTRACK
-A OUTPUT -d 127.0.0.0/8 -m comment --comment "030 NOTRACK traffic to
localhost" -j NOTRACK
COMMIT
# Completed on Thu Mar 19 04:09:15 2015
# Generated by iptables-save v1.4.12 on Thu Mar 19 04:09:15 2015
*filter
:INPUT DROP [3:390]
:FORWARD DROP [0:0]
:OUTPUT ACCEPT [409:39510]
-A INPUT -m comment --comment "005 allow related and established" -m conntrack
--ctstate RELATED,ESTABLISHED -j ACCEPT
-A INPUT -p tcp -m comment --comment "010 allow from ipset CleanHosts" -m set
--match-set CleanHosts src -j ACCEPT
-A INPUT -i lo -m comment --comment "015 allow all to lo interface" -j ACCEPT
-A INPUT -p tcp -m multiport --dports 22 -m comment --comment "020 allow all
ssh" -j ACCEPT
-A INPUT -p tcp -m comment --comment "025 allow consul tcp" -m set --match-set
ConsulTCPPorts dst -j ACCEPT
-A INPUT -p udp -m comment --comment "030 allow consul udp" -m set --match-set
ConsulUDPPorts dst -j ACCEPT
-A INPUT -p icmp -m comment --comment "035 allow all icmp" -j ACCEPT
-A INPUT -m comment --comment "999 log some dropped packets" -m limit --limit
5/min --limit-burst 10 -j LOG --log-prefix "IPTABLES Dropped: "
COMMIT
# Completed on Thu Mar 19 04:09:15 2015
```
