#!/bin/sh

IPTABLES=/sbin/iptables
IPTABLES_MODULES="nf_conntrack ip_tables ip6_tables x_tables"

# set default policies to accept
$IPTABLES -P INPUT ACCEPT
$IPTABLES -P FORWARD ACCEPT
$IPTABLES -P FORWARD ACCEPT
# flush rules in filter chains
$IPTABLES -F
# flush raw table
$IPTABLES -F -t raw

# function to get dependant modules
deps() {
  depmods=$(grep "^$1\ " | awk '{print $NF}' | tr ',' '\n')
  # sometimes above awk grabs the existing module without and deps
  # lets test to make sure we have a module name, any word
  echo $depmods | grep -qE '^[a-Z]+' && echo $depmods
}

# force remove any iptables modules, and dependants
for x in $IPTABLES_MODULES; do
  lsmod | deps $x | xargs -t -r rmmod
  rmmod $x 2> /dev/null
done
