class twitch_firewall (
  $enable = $twitch_firewall::params::enable,
) inherits twitch_firewall::params {

  validate_bool($enable)
  require twitch_netfilter

  # purge ALL unmanaged firewall rules on the host
  # if we're including this module, we're defining rules
  resources { 'firewall':
    purge => true
  }

  # load subclasses
  anchor { "${module_name}::start": } ->
  class { "${module_name}::install": } ->
  class { "${module_name}::ipset": } ->
  class { "${module_name}::pre": } ->
  class { "${module_name}::post": } ->
  anchor { "${module_name}::end": }

  # override ordering for all firewall resources
  # sets up ordering so pre rules always come before post rules
  # and others can come anywhere in between
  Firewall {
    require => Class["${module_name}::pre"],
    before  => Class["${module_name}::post"]
  }

  $default_input_policy = $enable ? {
    true  => 'drop',
    false => 'accept'
  }
  $enforce_chains = [
    'INPUT:filter:IPv4',
    'FORWARD:filter:IPv4',
  ]

  firewallchain { $enforce_chains:
    policy => $default_input_policy
  }

  # collect all rules, and place them before our end anchor
  Anchor["${module_name}::start"] ->
  Firewall <| |> ->
  Firewallchain <| |> ->
  Anchor["${module_name}::end"]

}
