class twitch_firewall::install inherits twitch_firewall {
  $needed_packages = [
    'ipset',
    'conntrack'
  ]

  package { $needed_packages: }

  # syslog all iptables logging to its own file
  ::rsyslog::snippet { '40-iptables':
    content => ":msg, startswith, \"IPTABLES Dropped: \" -/var/log/iptables.log\n& ~"
  }

  file { '/usr/local/sbin/nuke_iptables':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0750',
    source => "puppet:///modules/${module_name}/nuke_iptables.sh"
  }

}
