class twitch_firewall::ipset inherits twitch_firewall {

  file { '/root/ipset_helper.sh':
    ensure => 'present',
    source => "puppet:///modules/${module_name}/ipset_helper.sh"
  }

  # create ipset hashmaps for hosts
  twitch_firewall::ipset::create { ['DMZHosts', 'CleanHosts']: }

  $consul_map_type  = 'bitmap:port range 8300-8500'
  twitch_firewall::ipset::create { ['ConsulTCPPorts', 'ConsulUDPPorts']:
    type => $consul_map_type
  }

  $consul_tcp_ports = [
    '8300',
    '8301',
    '8302',
    '8400',
    '8500',
  ]
  $consul_udp_ports = [
    '8301',
    '8302',
  ]

  twitch_firewall::ipset::add { 'consul tcp ports':
    map      => 'ConsulTCPPorts',
    add_list => $consul_tcp_ports,
    type     => $consul_map_type
  }

  twitch_firewall::ipset::add { 'consul udp ports':
    map      => 'ConsulUDPPorts',
    add_list => $consul_udp_ports,
    type     => $consul_map_type
  }

  # whitelist certain cidrs here
  twitch_firewall::ipset::add { 'add to clean hosts':
    map      => 'CleanHosts',
    add_list => hiera_array('clean_ips', [])
  }

}
