# private API for calling `ipset add`
#
# [*map*]
#   ipset map name
#
define twitch_firewall::ipset::add(
  $map,
  $add_list,
  $type = 'hash:net'
) {

  include twitch_firewall

  validate_array($add_list)
  if !empty($add_list) {
    $add_string = join($add_list, ' ')
    # by default we use swap, because puppet is the authority
    exec { "Ensure $map":
      command => "echo '$add_string' | /root/ipset_helper.sh -x '$type' $map",
      require => [
        File['/root/ipset_helper.sh'],
        Twitch_firewall::Ipset::Create[$map]
      ]
    }
  }
}
