# This module installs freeipmi-tools and any dependancies.
# ipmi_si kernel module conflicts with these tools; blacklisted.

class twitch_freeipmi_tools (
  $version = $twitch_freeipmi_tools::params::version
) inherits twitch_freeipmi_tools::params {

  if ( $::virtual == 'physical' and $::manufacturer != 'Kontron' ) or $::packer_build_name {
    kmod::blacklist { 'ipmi_si': }
    -> kmod::load { 'ipmi_si': ensure => 'absent' }
    -> class { 'twitch_freeipmi_tools::packages': }
    ~> class { 'twitch_freeipmi_tools::service::ipmiseld': }
  }

}
