# Puppet clients either call init or call this.
# TODO: Make this rely on twitch_ganglia::ensure.
class twitch_ganglia::disabled {
  $systemd_conf = '/etc/systemd/system/ganglia-monitor.service'  # xenial
  $upstart_conf = '/etc/init/ganglia-monitor.conf'
  $init_d_file  = '/etc/init.d/ganglia-monitor'

  # Doing these as execs so we don't have to install the service first.
  exec { 'remove-ganglia-systemd':
    command => "systemctl stop ganglia-monitor; rm ${systemd_conf}",
    onlyif  => "test -f ${systemd_conf}",
  }

  exec { 'remove-ganglia-upstart':
    command => "service ganglia-monitor stop; rm ${upstart_conf}",
    onlyif  => "test -f ${upstart_conf}",
  }

  exec { 'remove-ganglia-init':
    command => "${init_d_file} stop && rm ${init_d_file}",
    onlyif  => "test -f ${init_d_file}",
    require => Exec['remove-ganglia-systemd', 'remove-ganglia-upstart'],
  }

  package { 'ganglia-monitor':
    ensure  => absent,
    require => Exec['remove-ganglia-init'],
  }
  # This will remove the cron from ~root and from /etc/cron.d/.
  twitch_cron { 'gmetric_disk_utilization_py':
    ensure => absent,
  }
  # Because people keep spinning up old AMIs with this cron in it.
  twitch_cron { 'twitch_ganglia::gmetric: disk_utilization.py':
    ensure => absent,
  }
}
