# Twitch ganglia module
class twitch_ganglia (
  $ganglia_netstats_enable = true,
  $ganglia_netstats_conf   = '',
  $ganglia_vm_stats_enable = true,
  $ganglia_cluster         = $twitch_ganglia::params::ganglia_cluster,
  $check_directory         = $twitch_ganglia::params::check_directory,
  $gmond_servers           = $twitch_ganglia::params::gmond_servers,
  $basedir                 = $twitch_ganglia::params::ganglia_basedir,
  $managed                 = $twitch_ganglia::params::managed,
) inherits twitch_ganglia::params {
  # All of these are used in templates.
  $gmond_ports             = $twitch_ganglia::params::gmond_ports
  $ganglia_conf_d          = "${basedir}/conf.d"

  if str2bool($managed) {
    if str2bool($::systemd) {
      # This is an old path we no longer use, and it can be removed eventually.
      file { '/lib/systemd/system/ganglia-monitor.service':
        ensure => absent,
        before => Twitch_systemd::Unit_file['ganglia-monitor.service'],
      }
      twitch_systemd::unit_file { 'ganglia-monitor.service':
        ensure  => 'present',
        content => template('twitch_ganglia/ganglia-monitor.service'),
        notify  => Service['ganglia-monitor'],
        before  => Package['ganglia-monitor'],
      }
    } else {
      file { '/etc/init/ganglia-monitor.conf':
        ensure => present,
        owner  => 'root',
        group  => 'root',
        mode   => '0644',
        source => 'puppet:///modules/twitch_ganglia/ganglia-monitor.conf',
        notify => Service['ganglia-monitor'],
        before => Package['ganglia-monitor'],
      }
    }

    package { 'jtv-gmond':
      ensure => absent,
    }

    package { 'ganglia-monitor':
      ensure => latest,
      notify => Exec['remove_sysv_links', 'kill_gmond_started_by_initd'],
    }

    file { '/etc/gmond.conf':
      ensure => absent,
    }

    file { "${basedir}/gmond.conf":
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template('twitch_ganglia/gmond.conf.erb'),
      require => Package['ganglia-monitor'],
      notify  => Service['ganglia-monitor'],
    }

    service { 'ganglia-monitor':
      ensure => running,
      enable => true,
    }

    exec { 'remove_sysv_links':
      command => '/usr/sbin/update-rc.d -f ganglia-monitor remove',
      onlyif  => 'test -L /etc/rc2.d/S20ganglia-monitor'
    }

    exec { 'kill_gmond_started_by_initd':
      command => '/etc/init.d/ganglia-monitor stop',
      onlyif  => 'pgrep -f -u ganglia "/usr/sbin/gmond$"',
      notify  => Service['ganglia-monitor']
    }

    if ($ganglia_netstats_enable) {
      twitch_ganglia::module { 'netstats':
        conf_type => $ganglia_netstats_conf,
      }
    }

    if ($ganglia_vm_stats_enable) {
      twitch_ganglia::module { 'vm_stats': }
    }

    twitch_ganglia::module { 'mem_stats': }
    twitch_ganglia::module { 'cpu_stats': }

    file { $ganglia_conf_d:
      ensure  => directory,
      owner   => root,
      group   => root,
      mode    => '0755',
      require => Package['ganglia-monitor'],
    }

    file { $twitch_ganglia::params::python_module_path:
      ensure  => directory,
      owner   => root,
      group   => root,
      mode    => '0755',
      require => Package['ganglia-monitor'],
      notify  => Service['ganglia-monitor'],
    }

    file { "${ganglia_conf_d}/modpython.conf":
      ensure  => present,
      owner   => root,
      group   => root,
      mode    => '0644',
      content => template('twitch_ganglia/modpython.conf.erb'),
      require => File[$twitch_ganglia::params::python_module_path],
      notify  => Service['ganglia-monitor'],
    }
  }
}
