# Installs ganglia modules.
define twitch_ganglia::module($conf_type='') {

  if ! ($::core::disable_ganglia) {
    include twitch_ganglia
    if str2bool($twitch_ganglia::managed) {
      $puppet_path     = 'puppet:///modules/twitch_ganglia/python_modules'
      $module_conf_ext = $conf_type ? {
        undef   => '',
        ''      => '',
        default => "-${conf_type}",
      }

      # install the actual module
      file { "${twitch_ganglia::python_module_path}/${name}.py":
        ensure => 'present',
        owner  => 'root',
        group  => 'root',
        mode   => '0755',
        source => "${puppet_path}/${name}.py",
        notify => Service['ganglia-monitor'],
      }

      # install the relevant ganglia config
      file { "${twitch_ganglia::ganglia_conf_d}/${name}.pyconf":
        ensure => 'present',
        owner  => 'root',
        group  => 'root',
        mode   => '0644',
        source => "${puppet_path}/${name}${module_conf_ext}.pyconf",
        notify => Service['ganglia-monitor'],
      }
    }
  }
}
