# Ganglia client and server parameters.
class twitch_ganglia::params {
  $check_directory    = '/usr/local/bin'  # gmetric check path
  $ganglia_basedir    = '/etc/ganglia'
  $python_module_path = '/usr/lib/ganglia/python_modules'
  $managed            = false
  $modpython_location = $::lsbdistcodename ? {
    'lucid' => '/usr/lib64/ganglia',
    default => '/usr/lib/ganglia',
  }

  # This variable configures "servers to send metrics to" on gmond clients.
  $gmond_servers = [
    'gmond-1.prod.vidops.twitch.a2z.com',
    'gmond-2.prod.vidops.twitch.a2z.com',
    'gmond-3.prod.vidops.twitch.a2z.com',
    'gmond-1.stage.vidops.twitch.a2z.com',
  ]

  # don't use ports 8651, 8652, 8659, 8679, 8697, or 8700
  # They're probably reserved. You may re-use ports.
  # If you remove a cluster, you must manualy stop the service            :(
  # on all 3 ganglia hosts: sudo systemctl stop mgmond@cluster.service
  $gmond_ports = {
    # START HERE AND INCREMENT 8649
    team-vod                => 8650,
    # DO NOT USE               8651
    # DO NOT USE               8652
    team-systems            => 8653,
    team-video              => 8654,
    unclassified            => 8655,
    team-neteng             => 8656,
    team-sec                => 8657,
    # DO NOT USE               8659
    mail                    => 8660,
    telegraph               => 8669,
    # DO NOT USE               8679
    usher                   => 8672,
    #video-pr                => 8673,
    video                   => 8674,
    #video-weaver            => 8675,
    #video-weaver-lb         => 8676,
    #video-service-int       => 8677,
    #video-service-ext       => 8678,
    # DO NOT USE               8697
    ingest                  => 8698,
    # DO NOT USE               8700
    hls                     => 8702,
    usher-web               => 8709,
    consul                  => 8716,
    usher-postgres          => 8724,
    rails-rabbitmq          => 8730,
    rails-postgres          => 8733,
    rails-varnish           => 8735,
    shim                    => 8737,
    postfix                 => 8740,
    nagios                  => 8743,
    ingest-proxy-edge       => 8744,
    #dns-cache               => 8746,
    #dns-hidden              => 8747,
    dns-resolver            => 8748,
    usher-pgbouncer         => 8755,
    video-api               => 8759,
    transcode               => 8777,
    video-tier1             => 8778,
    video-daemons           => 8800,
    video-cdncache          => 8801,
    pop-master              => 8802,
    trace                   => 8803,
    ingest-proxy-lb         => 8804,
    usher-memcached         => 8805,
    ganglia                 => 8806,
  }

  $ganglia_cluster = $cluster
}
