#!/usr/bin/env bash

dbs=(GeoIP2-Country.mmdb GeoIPCity.dat GeoIP.dat GeoIPv6.dat GeoLiteASNum.dat)
geoip_dir="/usr/share/GeoIP"

ensure()
{
    if [[ ! -e ${geoip_dir} ]]; then
        mkdir -p ${geoip_dir}
    fi
}

download()
{
    for db in "${dbs[@]}"; do
        wget -O ${geoip_dir}/${db}.incomplete https://packages.internal.justin.tv/artifactory/ip-twitch-geoip/current/${db}
        mv ${geoip_dir}/${db}.incomplete ${geoip_dir}/${db}
    done
}

ensure
download
