# Sets up geoip for Twitch.tv
class twitch_geoip (
  $env         = $twitch_geoip::params::env,
  $rotate_cron = $twitch_geoip::params::rotate_cron,
  $enable_cron = $twitch_geoip::params::enable_cron,
) inherits twitch_geoip::params {
  include wget

  validate_bool($enable_cron, $rotate_cron)

  twitch_sandstorm_agent::template { 'GeoIP.conf':
    owner       => 'root',
    group       => 'root',
    mode        => '0644',
    destination => '/etc/GeoIP.conf',
    ensure      => absent,
    allow_empty => true,
    delete_dest => true
  }

  if $rotate_cron {
    $cron_minutes = fqdn_rotate(range(0, 59))
    $cron_minute = $cron_minutes[0]
  } else {
    $cron_minute = 5
  }

  $cron_ensure = $enable_cron ? {
    true  => 'present',
    false => 'absent'
  }

  file{ '/opt/twitch/cronscripts':
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
  }

  file { 'download_geoip':
    ensure => present,
    path   => '/opt/twitch/cronscripts/download_geoip.sh',
    source => 'puppet:///modules/twitch_geoip/download_geoip.sh',
    owner  => 'root',
    group  => 'root',
    mode   => '0755'
  }

  twitch_cron { 'geoip_update':
    ensure  => $cron_ensure,
    user    => 'root',
    hour    => 2,
    minute  => $cron_minute,
    command => '/opt/twitch/cronscripts/download_geoip.sh > /dev/null 2>&1',
  }

  exec { 'init_geoip':
    user    => 'root',
    command => '/opt/twitch/cronscripts/download_geoip.sh',
    unless  => 'test -f /usr/share/GeoIP/GeoIPCity.dat -a -f /usr/share/GeoIP/GeoLiteASNum.dat -a -f /usr/share/GeoIP/GeoIP.dat -a -f /usr/share/GeoIP/GeoLite2-Country.mmdb',
  }
}
