# Workers quicksync resource
# Set the qs specific defaults here as only used by kontrons
class twitch_gotranscodermaster::quicksync (
  $max_proc_cpu   = 5,
  $cpu_max        = 85,
  $ensure         = $twitch_gotranscodermaster::ensure,
) inherits twitch_gotranscodermaster {

  twitch_gotranscodermaster::service { 'quicksync':
    ensure       => $ensure,
    max_proc_cpu => $max_proc_cpu,
    cpu_max      => $cpu_max,
    worker_type  => 'quicksync',
  }

  twitch_servicecheck::passive { 'gotranscodermaster-quicksync':
    command  => '/usr/local/bin/check-systemd-service -s gotranscodermaster@quicksync',
    interval => 5,
  }
}
