# Creates transcoders service
define twitch_gotranscodermaster::service (
  $ensure,
  $role            = undef,
  $pop             = undef,
  $env             = undef,
  $max_proc_cpu    = undef,
  $cpu_max         = 60,
  $worker_type     = undef,
) {
  include ::twitch_gotranscodermaster

  $_role = pick($role, $::twitch_gotranscodermaster::role)
  $_pop = pick($pop, $::twitch_gotranscodermaster::pop)
  $_env = pick($env, $::twitch_gotranscodermaster::env)
  # please don't override
  $config_path = $::twitch_gotranscodermaster::config_path

  validate_integer($cpu_max)
  validate_integer($max_proc_cpu)
  validate_re($worker_type, '^(transcode|transmux|quicksync)$', "Invalid worker type ${worker_type}. Supported worker types: transcode|transmux|quicksync.")
  validate_string($ensure)

  # WARNING: do not feed a hash to a value of these keys. The erb that consumes this sorts
  # the keys of the top level and place the raw value as the value to the key in yaml.
  $options = delete_undef_values({
    'environment'       => $_env,
    'hostclass'         => $_role,
    'pop'               => $_pop,
    'workertype'        => $worker_type,
    'maxproccountlimit' => $max_proc_cpu,
    'maxcpulimit'       => $cpu_max,
  })

  $cfg_ensure = $ensure ? {
    'present' => 'file',
    default   => 'absent',
  }

  # config file
  file { "${config_path}/gotranscodermaster-${worker_type}.yaml":
    ensure  => $cfg_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/gotranscoder.yaml.erb"),
  }

  # VIDCS-2715 clean up non-template service
  exec { "stop old gotranscodermaster-${worker_type} systemd unit":
    command => "systemctl stop gotranscodermaster-${worker_type}",
    onlyif  => "test -f /etc/systemd/system/gotranscodermaster-${worker_type}.service",
  }
  -> systemd::service { "gotranscodermaster-${worker_type}":
    ensure => 'absent',
  }

}
