# Workers resource
# this can all be replaced with a simple .each when we hit puppet >=4
class twitch_gotranscodermaster::transcode (
  $max_proc_cpu   = $twitch_gotranscodermaster::max_proc_cpu,
  $cpu_max        = $twitch_gotranscodermaster::cpu_max,
  $ensure         = $twitch_gotranscodermaster::ensure,
) inherits twitch_gotranscodermaster {

  $default_max_proc_count = $::processor0 ? {
    /E5-2630 v4/ => '3',
    default      => '2',
  }

  $max_proc_count = $max_proc_cpu ? {
    undef   => $default_max_proc_count,
    default => $max_proc_cpu,
  }

  twitch_gotranscodermaster::service { 'transcode':
    ensure       => $ensure,
    max_proc_cpu => $max_proc_count,
    cpu_max      => $cpu_max,
    worker_type  => 'transcode',
  }

  twitch_servicecheck::passive { 'gotranscodermaster-transcode':
    command  => '/usr/local/bin/check-systemd-service -s gotranscodermaster@transcode',
    interval => 5,
  }

}
