# Workers resource
# this can all be replaced with a simple .each when we hit puppet >=4
class twitch_gotranscodermaster::transmux (
  # Only x-2 use this for now, so we are setting these defaults
  $max_proc_cpu   = 225,
  $cpu_max        = 80,
  $ensure         = $twitch_gotranscodermaster::ensure,
) inherits twitch_gotranscodermaster {

  twitch_gotranscodermaster::service { 'transmux':
    ensure       => $ensure,
    max_proc_cpu => $max_proc_cpu,
    cpu_max      => $cpu_max,
    worker_type  => 'transmux',
  }

  twitch_servicecheck::passive { 'gotranscodermaster-transmux':
    command  => '/usr/local/bin/check-systemd-service -s gotranscodermaster@transmux',
    interval => 5,
  }

}
