# Installs and configures haproxy-metrics-collector, a Go binary which reads
# HAProxy stats sockets, parses the output, and sends the results to StatsD.
# By default, it runs as a cron job once per minute.
class twitch_haproxy::collector(
  $package_version = '0.1.3',
  $cluster         = 'testing',
  $socket_dir      = '/var/run',
  $socket_pattern  = 'haproxy-*.sock',
  $statsd_server   = 'graphite-ingest.central.twitch.a2z.com:8125',
) {
  package { 'haproxy-metrics-collector':
    ensure => $package_version,
  }

  file { '/etc/cron.d/haproxy-metrics-collector':
    content => template("${module_name}/haproxy_collector_cron.erb"),
    require => Package['haproxy-metrics-collector'],
  }
}
