# == Class: twitch_haproxy
#
# Installs haproxy and creates conf directory and chroot directory
#
# === Parameters
#
# [*haproxy_ensure*]
#  Installs specific version of haproxy with package resource, Default: <see params.pp>
#
# [*haproxy_chroot_dir*]
#  Chroot directory for haproxy, Default: /var/chroot/haproxy
#
# [*haproxy_conf_dir*]
#  Config directory for haproxy, Default: /etc/haproxy
#
class twitch_haproxy (
  $haproxy_ensure     = $twitch_haproxy::params::haproxy_ensure,
  $haproxy_chroot_dir = $twitch_haproxy::params::haproxy_chroot_dir,
  $haproxy_conf_dir   = $twitch_haproxy::params::haproxy_conf_dir,
) inherits twitch_haproxy::params {

  require twitch_dirs

  package{ 'haproxy':
    ensure => $haproxy_ensure,
  }

  file{ $haproxy_chroot_dir:
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Package['haproxy'],
  }

  file{ [ $haproxy_conf_dir, "${haproxy_conf_dir}/ssl" ]:
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Package['haproxy'],
  }

  # does this do anything??
  if versioncmp($haproxy_ensure, '1.8.0') >= 0 {
    $haproxy_systemd_wrapper = true
  } else {
    $haproxy_systemd_wrapper = false
  }

}
