# == Class: twitch_haproxy::params
#
# This is a container class holding default parameters for for haproxy class.
#  currently, only the Redhat family is supported, but this can be easily
#  extended by changing package names and configuration file paths.
#
class twitch_haproxy::params {

  $haproxy_conf_dir = '/etc/haproxy'
  $haproxy_chroot_dir = '/var/chroot/haproxy'

  case $::osfamily {
    'Archlinux', 'Debian', 'Redhat': {
      $package_name      = 'haproxy'
      $_global_options   = {
        'log'               => '127.0.0.1 local3',
        'chroot'            => $haproxy_chroot_dir,
        'pidfile'           => '/var/run/haproxy.pid',
        'maxconn'           => '4000',
        'user'              => 'www-data',
        'group'             => 'www-data',
        'daemon'            => '',
        'quiet'             => '',
        'server-state-base' => '/var/run/',
        'nbproc'            => 1
      }
      $_defaults_options = {
        'log'                         => 'global',
        'balance'                     => 'roundrobin',
        'load-server-state-from-file' => 'global',
        'maxconn'                     => '4000',
        'option'                      => [
          'redispatch',
          'tcplog',
          'tcpka',
          'contstats'
        ],
        'timeout'                     => [
          'connect 10s',
          'client 1m',
          'server 1m',
        ],
      }
    }
    default: { fail("The ${::osfamily} operating system is not supported with the haproxy module") }
  }

  $haproxy_ensure = $::lsbdistcodename ? {
    bionic  => '2.2.9-12bionic',
    xenial  => '1.7.5-2xenial',
    default => absent
  }

  $enable_url_stats = false

  if versioncmp($::kernelmajversion, '3.9') >= 0 {
    $reuseport_supported = true
  } else {
    $reuseport_supported = false
  }

}
