# == Define Resource Type: twitch_haproxy::static_consul_backend
#
# This type will setup a backend service configuration block inside
#  the config file on an haproxy load balancer identified by $instance_name.
#  Each backend service configuration needs one or more load balancer member
#  server (that should be pass in via the $server_list param as an array).
#
# === Requirement/Dependencies:
#
# Currently requires the ripienaar/concat module on the Puppet Forge
#
# === Parameters
#
# [*name*]
#  The namevar of the defined resource type is the backend service's name.
#  This name goes right after the 'backend' statement in haproxy.cfg
#
# [*default_remote_port*]
#  This port number will be appended to each server if a port is not part of 
#   server name.
#
# [*options*]
#  A hash of options that are inserted into the backend service
#   configuration block.  This hash will write key / value pairs
#   to the configuration file.  For single world parameters, provide a
#   value of '' (ex. daemon).  For keys that are not unique (ex. option),
#   supply an array of parameters.
#
# [*server_options*]
#  A string of options that will be appended to every server from $server_list
#
# [*instance_name*]
#   The name of the haproxy instance for which the config will be written.
#   Allows for multiple haproxy instances on a single machine.
#
# [*backend_template*]
#   Override of the default template to write backend blocks
#
# [*server_template*]
#   Override of the default template to write server lines with backend blocks.
#
# [*server_content*]
#   Override of the server config entries. If used, no server template is used
#   and the caller should generate the proper config entries.
#
# [*consul_services*]
#   Output from `consul_service_lookup` function
#
# [*prefer_localhost*]
#   If true, makes non-localhost servers backups
#
define twitch_haproxy::static_consul_backend (
  $consul_services,
  $instance_name,
  $options          = {
    'mode'    => 'http'
  },
  $backend_template  = 'twitch_haproxy/haproxy_backend_block.erb',
  $server_template  = 'twitch_haproxy/haproxy_static_consul_listen_block_servers.erb',
  $server_options   = '',
  $prefer_localhost = false,
) {

  validate_array($consul_services)

  twitch_haproxy::backend { $name:
    instance_name       => $instance_name,
    options             => $options,
    backend_template    => $backend_template,
    server_options      => $server_options,
    server_content      => template($server_template),
    default_remote_port => -1,
  }
}
