define twitch_haproxy::stats(
  $instance_name,
  $options,
  $ip,
  $port_to_process,
  $ensure = 'present',
) {
  validate_numeric($name)
  validate_hash($port_to_process)
  validate_re($ensure, [ '^present$', '^absent$' ])

  $process = $port_to_process[$name]
  if is_numeric($process) {
    $opts = merge($options, { 'bind-process' => $process })
  } else {
    $opts = $options
  }

  twitch_haproxy::listen{ "stats-${instance_name}-${name}":
    ensure              => $ensure,
    instance_name       => $instance_name,
    options             => $opts,
    ports               => [$name],
    ipaddress           => $ip,
    default_remote_port => $name,
  }
}
