require 'spec_helper'

describe 'twitch_haproxy::backend', :type => :define do
  let(:facts) do {
    :osfamily        => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress       => '127.0.0.1',
    :concat_basedir  => '/var/lib/puppet/concat',
  }
  end

  context 'verify module' do
    let(:title) { 'mytest' }
    let(:params) do {
      :default_remote_port => '8001',
    }
    end

    it "does contain concat::fragment for backend config" do
      should contain_concat__fragment("#{title}_backend_block")
    end

    it "does contain concat::fragment for backend server config" do
      should contain_concat__fragment("#{title}_backend_block_servers")
    end

  end
end
