require 'spec_helper'

describe 'twitch_haproxy::instance', :type => :define do
  let(:facts) do {
    :osfamily        => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress       => '127.0.0.1',
    :concat_basedir  => '/var/lib/puppet/concat',
  }
  end

  context 'verify module' do
    let(:title) { 'mytest' }
    let(:params) do {
      :svc_name         => 'mytest',
      :global_options   => {'key1' => 'one','key2' => 'two'},
      :defaults_options => {'key3' => 'three','key4' => 'four'},
    }
    end

    it 'does contain create twitch_haproxy::global' do
      should contain_twitch_haproxy__global(params[:svc_name])
    end

    it 'does contain create twitch_haproxy::listen for stats' do
      should contain_twitch_haproxy__listen("stats-#{params[:svc_name]}")
    end

    it 'does contain service' do
      should contain_service("haproxy_#{params[:svc_name]}")
    end

    it 'does contain init script' do
      should contain_file("/etc/init.d/haproxy_#{params[:svc_name]}")
    end
  end
end
