require 'spec_helper'

describe 'twitch_haproxy::listen', :type => :define do
  let(:facts) do {
    :osfamily        => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress       => '127.0.0.1',
    :concat_basedir  => '/var/lib/puppet/concat',
  }
  end

  context 'verify module' do
    let(:title) { 'mytest' }
    let(:params) do {
      :ports               => '81',
      :default_remote_port => '8001',
    }
    end

    it 'does contain header for haproxy config' do
      should contain_concat__fragment("#{title}_listen_block").with({
        :order => "20-#{title}-00",
      })
    end

    it 'does contain global and defaults sections of config' do
      should contain_concat__fragment("#{title}_listen_block_servers").with({
        :order => "20-#{title}-01",
      })
    end

  end
end
