class twitch_hermes (
  $deploy_environment = $twitch_hermes::params::deploy_environment,
  $canary             = $twitch_hermes::params::canary,
  $user               = $twitch_hermes::params::user,
  $config_location    = $twitch_hermes::params::config_location,
  $max_memory         = $twitch_hermes::params::max_memory,
  $max_cpus           = $twitch_hermes::params::max_cpus,
  $app_name           = $twitch_hermes::params::app_name,
  $ttl                = $twitch_hermes::params::ttl,
  $ensure             = $twitch_hermes::params::ensure,
) inherits twitch_hermes::params {
  validate_string($deploy_environment, $user, $config_location)

  # lint:ignore:only_variable_string
  validate_re("${max_cpus}", '^[0-9]+$')
  # lint:endignore

  # install service, before applying anycast IPs
  anchor { 'twitch_hermes::begin': }
  -> class { 'twitch_hermes::service': }
  -> anchor { 'twitch_hermes::end': }
}
