class twitch_hermes::service (
) inherits twitch_hermes {
  # ugly i know, but we're completely decomming this post xenial :P
  if $::twitch_hermes::ensure == 'present' {
    # Install the libcap2-bin package to get `setcap`. This allow us to bind to
    # port 53 as a non-root user.
    include twitch::packages
    realize(Package['libcap2-bin'])

    $config = delete_undef_values({
      # The `0 + ` code forces puppet to encode the port as an int instead of as a
      # string. i.e. `53` vs `"53"`.
      'port'        => 0 + 53,
      'nameservers' => delete_undef_values({
        'ns1-dnsmonitoring.ttvnw.net.' =>  delete_undef_values({}),
        'ns2-dnsmonitoring.ttvnw.net.' =>  delete_undef_values({}),
      }),
      # The `0 + ` code forces puppet to encode the ttl as an int instead of as a
      # string. i.e. `300` vs `"300"`.
      'ttl'         => 0 + $twitch_hermes::ttl,
      'domains'     => delete_undef_values({
        'requests.dnsmonitoring.ttvnw.net.' => delete_undef_values({}),
      }),
      'pop'         => $::pop,
      'environment' => $twitch_hermes::deploy_environment,
      'fqdn'        => $::fqdn,
    })

    $cgroups_rules = {
      'memory' => {
        'memory.limit_in_bytes' => to_bytes($twitch_hermes::max_memory),
        'memory.swappiness'     => 0,
      }
    }

    file { 'hermes_config':
      path    => $twitch_hermes::config_location,
      mode    => '0444',
      content => pretty_json($config),
      owner   => 'root',
      group   => 'root',
      notify  => Daemontools::Supervise[$twitch_hermes::app_name],
    }

    twitch::service { $twitch_hermes::app_name:
      env            => $twitch_hermes::deploy_environment,
      canary         => $twitch_hermes::canary,
      manage_service => true,
      daemon_cmd     => "./hermes-responder -config '${twitch_hermes::config_location}'",
      predaemon      => [
        'test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh',
        "setcap 'cap_net_bind_service=+ep' /opt/twitch/${twitch_hermes::app_name}/current/hermes-responder",
        "export GOMAXPROCS=${twitch_hermes::max_cpus}",
      ],
      service_repo   => 'video/hermes',
      user           => $twitch_hermes::user,
      enable_cgroups => true,
      cgroups_rules  => $cgroups_rules,
      require        => Package['libcap2-bin'],
    }
  }
}
