# twitch_initramfs_tools
class twitch_initramfs_tools {

  require twitch_apt
  require twitch_kernel

  include twitch_initramfs_tools::params

  $packages = ['initramfs-tools', 'xz-utils']

  package { $packages:
    ensure => 'present',
  }

  -> file_line { 'compress initramfs with xz':
    path  => '/etc/initramfs-tools/initramfs.conf',
    line  => 'COMPRESS=xz',
    match => '^COMPRESS=gzip$',
  }

  -> file_line { 'load required modules in initramfs':
    path  => '/etc/initramfs-tools/initramfs.conf',
    line  => "MODULES=${twitch_initramfs_tools::params::modules_type}",
    match => '^MODUELS=(most|dep)$',
  }

  -> file_line { 'disable update-initramfs':
    path  => '/etc/initramfs-tools/update-initramfs.conf',
    line  => "update_initramfs=${twitch_initramfs_tools::params::disable_update_initramfs}",
    match => '^update_initramfs=(yes|no)$',
  }

}
