# twitch_intelligest::certs
#
# class which defines certificates used for Intelligest
# uses local ssl_certificate define to abstract out 1 certificate instance
class twitch_intelligest::certs {
  include twitch_intelligest

  twitch_intelligest::ssl_certificate { 'wildcard_twitch_tv':
    sandstorm_cert_path => "video/ssl_keys/${twitch_intelligest::env}/wildcard_twitch_tv/pem",
    sandstorm_key_path  => "video/ssl_keys/${twitch_intelligest::env}/wildcard_twitch_tv/key",
  }

  # IVS
  # Production needs
  # *.contribute.live-video.net , *.global-contribute.live-video.net , *.rist.live-video.net , *.webrtc.live-video.net
  # Staging needs:
  # *.staging.contribute.live-video.net , *.rist-staging.live-video.net , *.webrtc-staging.live-video.net
  case $twitch_intelligest::env {
    'production': {
      twitch_intelligest::ssl_certificate { 'wildcard_contribute_live-video_net':
        sandstorm_cert_prefix => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_contribute_live-video_net",
        sandstorm_key_path    => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_contribute_live-video_net/key",
      }
      twitch_intelligest::ssl_certificate { 'wildcard_global-contribute_live-video_net':
        sandstorm_cert_prefix => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_global-contribute_live-video_net",
        sandstorm_key_path    => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_global-contribute_live-video_net/key",
      }
      twitch_intelligest::ssl_certificate { 'wildcard_rist_live-video_net':
        sandstorm_cert_prefix => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_rist_live-video_net",
        sandstorm_key_path    => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_rist_live-video_net/key",
      }
      twitch_intelligest::ssl_certificate { 'wildcard_webrtc_live-video_net':
        sandstorm_cert_prefix => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_webrtc_live-video_net",
        sandstorm_key_path    => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_webrtc_live-video_net/key",
      }
    }
    'staging': {
      twitch_intelligest::ssl_certificate { 'wildcard_staging_contribute_live-video_net':
        sandstorm_cert_prefix => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_staging_contribute_live-video_net",
        sandstorm_key_path    => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_staging_contribute_live-video_net/key",
      }
      twitch_intelligest::ssl_certificate { 'wildcard_rist-staging_live-video_net':
        sandstorm_cert_prefix => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_rist-staging_live-video_net",
        sandstorm_key_path    => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_rist-staging_live-video_net/key",
      }
      twitch_intelligest::ssl_certificate { 'wildcard_webrtc-staging_live-video_net':
        sandstorm_cert_prefix => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_webrtc-staging_live-video_net",
        sandstorm_key_path    => "video/ingest-proxy/${twitch_intelligest::env}/wildcard_webrtc-staging_live-video_net/key",
      }
    }
  }

}
