# default params to twitch_intelligest
class twitch_intelligest::params {
  $aws_region             = $::facts['default_region']
  $base_path              = '/opt/twitch/intelligest'
  $conf_dir               = '/etc/intelligest'
  $config_file            = "${conf_dir}/intelligest.yaml"
  $user                   = 'intelligest'
  $group                  = 'intelligest'
  $module_dir             = "${conf_dir}/modules"
  $enabled_modules        = hiera_array('twitch_intelligest::modules', [])
  # Local Consul address where Intelligest can talk to.
  $consul_addr            = '127.0.0.1:8500'
  $rtmp_port              = 1935
  $rtmps_port             = 443
  # How often Intelligest checks the local Consul to get
  # ingest-proxy-lb lists.
  $consul_check_interval  = '120s'
  $env                    = pick($::twitch_environment, $twitch_environment, 'staging')
  # How often a health check is done for a host in a backend.
  $host_check_interval    = '60s'
  # Indicate if IPE is private ingest
  $is_private_ingest      = false
  # Maximum number of connections the process can handle.
  $max_connections        = 1000
  # default number of instances to spawn
  $num_instances          = $::facts['processorcount'] / 2
  $pop_map_check_interval = '30s'
  # Indicates environment i.e. prod, staging, etc
  $substage               = 'primary'
  $tls_dir                = "${conf_dir}/tls"
  # used to set process limits via Systemd
  $ulimit_n               = 5000
  # Set platform i.e., baremetal, aws, etc
  $platform               = 'baremetal'
  # Set backend provider i.e., consul, liveproxyapi, etc
  $backend_provider       = 'consul'
}
